<?php

$link = $props['link'] ? $this->el('a', [
    'href' => $props['link'],
    'target' => ['_blank {@link_target}'],
    'uk-scroll' => str_contains((string) $props['link'], '#'),
]) : null;

if ($link && $element['overlay_link']) {

    $el->attr($link->attrs + [

        'class' => [
            'uk-display-block',

            // Needs to be child of `uk-light` or `uk-dark`
            'uk-link-toggle',
        ],

        'aria-label' => $props['link_aria_label'],

    ]);

    $props['title'] = $this->striptags($props['title']);
    $props['meta'] = $this->striptags($props['meta']);
    $props['content'] = $this->striptags($props['content']);

    if ($props['title'] && $element['title_hover_style'] != 'reset') {
        $props['title'] = $this->el('span', [
            'class' => [
                'uk-link-{title_hover_style: heading}',
                'uk-link {!title_hover_style}',
            ],
        ], $props['title'])->render($element);
    }

}

if ($link && $props['title'] && $element['title_link']) {

    $props['title'] = $link($element, [
        'class' => [
            'uk-link-{title_hover_style}',
        ],
    ], $this->striptags($props['title']));

}

if ($link && ($props['link_text'] || $element['link_text'])) {

    if ($element['overlay_link']) {
        $link = $this->el('div');
    }

    $link->attr('class', [
        'el-link',
        'uk-{link_style: link-(muted|text)}',
        'uk-button uk-button-{!link_style: |link-muted|link-text} [uk-button-{link_size}] [uk-width-1-1 {@link_fullwidth}]',
        'uk-transition-{link_transition} {@overlay_hover}',
        // Keep link style if overlay link
        'uk-link {@link_style:} {@overlay_link}',
        'uk-text-muted {@link_style: link-muted} {@overlay_link}',
    ]);

}

return $link;
